#include-once
#include <GDIPlus.au3>
#include <WinAPI.au3>
#include <ScreenCapture.au3>

; simple screen-capture ;o)

_GDIPlus_Startup()

$hGUI = WinGetHandle("AutoIt Help")
WinMove($hGUI, "", @DesktopWidth-100, @DesktopHeight)

$iWidth = _WinAPI_GetWindowWidth($hGUI)
$iHeight = _WinAPI_GetWindowHeight($hGUI)

$hParent = GUICreate("WindowViewer", 500, 400)
$hGraphics = _GDIPlus_GraphicsCreateFromHWND($hParent)
GUISetState()

$hBMP = _WinCapture($hGUI, $iWidth, $iHeight)
$hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)

_GDIPlus_GraphicsDrawImageRectRect($hGraphics, $hImage, 0, 0, $iWidth, $iHeight, 50, 50, 400, 300)
_GDIPlus_ImageDispose($hImage)
_GDIPlus_GraphicsDispose($hGraphics)
_WinAPI_DeleteObject($hBMP)
Sleep(5000)



Func _WinCapture($hWnd, $iWidth = -1, $iHeight = -1)
    Local $iH, $iW, $hDDC, $hCDC, $hBMP

    If $iWidth = -1 Then $iWidth = _WinAPI_GetWindowWidth($hWnd)
    If $iHeight = -1 Then $iHeight = _WinAPI_GetWindowHeight($hWnd)

    $hDDC = _WinAPI_GetDC($hWnd)
    $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
    $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
    _WinAPI_SelectObject($hCDC, $hBMP)

    DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", 0)
    _WinAPI_BitBlt($hCDC, 0, 0, $iW, $iH, $hDDC, 0, 0, 0x00330008)

    _WinAPI_ReleaseDC($hWnd, $hDDC)
    _WinAPI_DeleteDC($hCDC)

    _ScreenCapture_SaveImage(@DesktopDir&"\window.jpg", $hBMP, False)

    Return $hBMP
EndFunc   ;==>_WinCapture